#include "core.h"
#include "master.h"
#include <stdio.h>
#include "rt.h"
SRCFILE("main.c")

extern "C" {
	extern char version[];
}

void ErrExit(char *e)
{
	fprintf(stderr, "%s\n", e);
	exit(1);
}

char *TAPTO;
char *PATH;
char *SRCPATH;

void PadsRemInit();
char *PadsTermInit(int, char**, char*);

void LoadTerm(int argc, char **av)
{
	if (av[1] && !strcmp(av[1],"-R")) {
		PadsRemInit();
		return;
	}
	if (av[1] && !strcmp(av[1],"-r") && av[2])
		ErrExit(PadsTermInit(argc, av, av[2]));
	if( PadsInit(argc, av) )
		ErrExit("cannot load terminal");
}

void main(int argc, char **av)
{
	if( argc == 2 && !strcmp(av[1],"-V") ){
		printf(version);
		exit(0);
	}
	PATH = getenv("PATH");
	SRCPATH = getenv("PI_SRCPATH");
	::signal(SIGCLD, SIG_IGN);
	LoadTerm(argc, av);
	extern char *TapTo;
	TapTo = TAPTO;
	NewHelp();
	NewWd();
	new RtConnections;
	PadsServe();
}
